/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintElementContainer;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.PrintElementId;
import net.sf.jasperreports.engine.PrintElementVisitor;
import net.sf.jasperreports.engine.base.VirtualizableElementList;
import net.sf.jasperreports.engine.fill.JRTemplateFrame;
import net.sf.jasperreports.engine.fill.JRTemplatePrintElement;
import net.sf.jasperreports.engine.fill.JRVirtualizationContext;
import net.sf.jasperreports.engine.fill.PrintElementOriginator;
import net.sf.jasperreports.engine.virtualization.VirtualizationInput;
import net.sf.jasperreports.engine.virtualization.VirtualizationOutput;

public class JRTemplatePrintFrame
extends JRTemplatePrintElement
implements JRPrintFrame,
JRPrintElementContainer {
    private static final long serialVersionUID = 10200L;
    private List<JRPrintElement> elements;

    public JRTemplatePrintFrame() {
    }

    public JRTemplatePrintFrame(JRTemplateFrame templateFrame, PrintElementOriginator originator) {
        super(templateFrame, originator);
        this.elements = new ArrayList<JRPrintElement>();
    }

    protected void setElementsList(List<JRPrintElement> elements) {
        this.elements = elements;
    }

    @Override
    public List<JRPrintElement> getElements() {
        return this.elements;
    }

    @Override
    public void addElement(JRPrintElement element) {
        this.elements.add(element);
    }

    public void addElements(Collection<? extends JRPrintElement> elements) {
        this.elements.addAll(elements);
    }

    @Override
    public JRLineBox getLineBox() {
        return ((JRTemplateFrame)this.template).getLineBox();
    }

    @Override
    public Color getDefaultLineColor() {
        return this.getForecolor();
    }

    @Override
    public <T> void accept(PrintElementVisitor<T> visitor, T arg) {
        visitor.visit(this, arg);
    }

    @Override
    public void writeVirtualized(VirtualizationOutput out) throws IOException {
        super.writeVirtualized(out);
        if (this.elements instanceof VirtualizableElementList) {
            VirtualizableElementList virtualizableList = (VirtualizableElementList)this.elements;
            JRVirtualizationContext virtualizationContext = virtualizableList.getVirtualizationContext();
            virtualizationContext.cacheVirtualizableList(PrintElementId.forElement(this), virtualizableList);
            out.writeIntCompressed(-1);
        } else {
            out.writeIntCompressed(this.elements.size());
            for (JRPrintElement element : this.elements) {
                out.writeJRObject(element, true, false);
            }
        }
    }

    @Override
    public void readVirtualized(VirtualizationInput in) throws IOException {
        super.readVirtualized(in);
        int size = in.readIntCompressed();
        if (size < 0) {
            this.elements = in.getVirtualizationContext().getVirtualizableList(PrintElementId.forElement(this));
        } else {
            this.elements = new ArrayList<JRPrintElement>(size);
            for (int i = 0; i < size; ++i) {
                JRPrintElement element = (JRPrintElement)in.readJRObject();
                this.elements.add(element);
            }
        }
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
        if (this.elements instanceof VirtualizableElementList) {
            VirtualizableElementList virtualizableList = (VirtualizableElementList)this.elements;
            JRVirtualizationContext virtualizationContext = virtualizableList.getVirtualizationContext();
            virtualizationContext.cacheVirtualizableList(PrintElementId.forElement(this), virtualizableList);
        }
    }
}

