/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services;

import com.googlecode.cqengine.attribute.Attribute;
import java.util.Collection;
import java.util.List;
import java.util.function.BiPredicate;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.ServicesManagerRegisteredServiceLocator;
import org.apereo.cas.services.query.BasicRegisteredServiceQueryIndex;
import org.apereo.cas.services.query.RegisteredServiceQueryAttribute;
import org.apereo.cas.services.query.RegisteredServiceQueryIndex;
import org.apereo.cas.util.CollectionUtils;

public abstract class BaseServicesManagerRegisteredServiceLocator
implements ServicesManagerRegisteredServiceLocator {
    private int order = -1000;
    private BiPredicate<RegisteredService, Service> registeredServiceFilter = (registeredService, service) -> {
        boolean supportedType = this.supports((RegisteredService)registeredService, (Service)service);
        return supportedType && registeredService.matches(service.getId());
    };

    public RegisteredService locate(Collection<? extends RegisteredService> candidates, Service service) {
        return candidates.stream().filter(registeredService -> this.supports((RegisteredService)registeredService, service)).filter(registeredService -> this.registeredServiceFilter.test((RegisteredService)registeredService, service)).findFirst().orElse(null);
    }

    public boolean supports(RegisteredService registeredService, Service service) {
        Pair<String, Class<? extends RegisteredService>> serviceType = this.getRegisteredServiceIndexedType();
        return ((Class)serviceType.getValue()).isAssignableFrom(registeredService.getClass()) && registeredService.getFriendlyName().equalsIgnoreCase((String)serviceType.getKey());
    }

    public List<RegisteredServiceQueryIndex> getRegisteredServiceIndexes() {
        Class registeredServiceIndexedType = (Class)this.getRegisteredServiceIndexedType().getValue();
        return CollectionUtils.wrapArrayList((Object[])new RegisteredServiceQueryIndex[]{BasicRegisteredServiceQueryIndex.hashIndex((Attribute)new RegisteredServiceQueryAttribute(registeredServiceIndexedType, Long.TYPE, "id")), BasicRegisteredServiceQueryIndex.hashIndex((Attribute)new RegisteredServiceQueryAttribute(registeredServiceIndexedType, String.class, "name")), BasicRegisteredServiceQueryIndex.hashIndex((Attribute)new RegisteredServiceQueryAttribute(registeredServiceIndexedType, String.class, "serviceId")), BasicRegisteredServiceQueryIndex.hashIndex((Attribute)new RegisteredServiceQueryAttribute(registeredServiceIndexedType, String.class, "friendlyName")), BasicRegisteredServiceQueryIndex.hashIndex((Attribute)new RegisteredServiceQueryAttribute(registeredServiceIndexedType, String.class, "@class"))});
    }

    protected abstract Pair<String, Class<? extends RegisteredService>> getRegisteredServiceIndexedType();

    @Generated
    public BaseServicesManagerRegisteredServiceLocator(int order, BiPredicate<RegisteredService, Service> registeredServiceFilter) {
        this.order = order;
        this.registeredServiceFilter = registeredServiceFilter;
    }

    @Generated
    public BaseServicesManagerRegisteredServiceLocator() {
    }

    @Generated
    public void setOrder(int order) {
        this.order = order;
    }

    @Generated
    public void setRegisteredServiceFilter(BiPredicate<RegisteredService, Service> registeredServiceFilter) {
        this.registeredServiceFilter = registeredServiceFilter;
    }

    @Generated
    public int getOrder() {
        return this.order;
    }

    @Generated
    public BiPredicate<RegisteredService, Service> getRegisteredServiceFilter() {
        return this.registeredServiceFilter;
    }
}

