/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.compatibility;

import org.flowable.engine.compatibility.Flowable5CompatibilityHandler;
import org.flowable.engine.compatibility.Flowable5CompatibilityHandlerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultFlowable5CompatibilityHandlerFactory
implements Flowable5CompatibilityHandlerFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultFlowable5CompatibilityHandlerFactory.class);
    protected String compatibilityHandlerClassName;

    @Override
    public Flowable5CompatibilityHandler createFlowable5CompatibilityHandler() {
        if (this.compatibilityHandlerClassName == null) {
            this.compatibilityHandlerClassName = "org.flowable.compatibility.DefaultFlowable5CompatibilityHandler";
        }
        try {
            Flowable5CompatibilityHandler handler = (Flowable5CompatibilityHandler)Class.forName(this.compatibilityHandlerClassName).getConstructor(new Class[0]).newInstance(new Object[0]);
            return handler;
        }
        catch (Exception e) {
            LOGGER.info("Flowable 5 compatibility handler implementation not found or error during instantiation : {}. Flowable 5 backwards compatibility disabled.", (Object)e.getMessage());
            return null;
        }
    }

    public String getCompatibilityHandlerClassName() {
        return this.compatibilityHandlerClassName;
    }

    public void setCompatibilityHandlerClassName(String compatibilityHandlerClassName) {
        this.compatibilityHandlerClassName = compatibilityHandlerClassName;
    }
}

