/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.rest.api.service;

import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.security.SecurityRequirements;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.List;
import org.apache.syncope.common.lib.to.ImplementationTO;
import org.apache.syncope.common.rest.api.service.JAXRSService;

@Tag(name="Implementations")
@SecurityRequirements(value={@SecurityRequirement(name="BasicAuthentication"), @SecurityRequirement(name="Bearer")})
@Path(value="implementations")
public interface ImplementationService
extends JAXRSService {
    @GET
    @Path(value="{type}")
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public List<ImplementationTO> list(@NotNull @PathParam(value="type") String var1);

    @GET
    @Path(value="{type}/{key}")
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public ImplementationTO read(@NotNull @PathParam(value="type") String var1, @NotNull @PathParam(value="key") String var2);

    @Parameters(value={@Parameter(name="type", description="Implementation's type", in=ParameterIn.PATH, schema=@Schema(type="string")), @Parameter(name="key", description="Implementation's key", in=ParameterIn.PATH, schema=@Schema(type="string"))})
    @POST
    @Path(value="{type}/{key}")
    @Consumes(value={"application/json", "application/yaml", "application/xml"})
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public Response create(@NotNull ImplementationTO var1);

    @Parameters(value={@Parameter(name="type", description="Implementation's type", in=ParameterIn.PATH, schema=@Schema(type="string")), @Parameter(name="key", description="Implementation's key", in=ParameterIn.PATH, schema=@Schema(type="string"))})
    @PUT
    @Path(value="{type}/{key}")
    @Consumes(value={"application/json", "application/yaml", "application/xml"})
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public Response update(@NotNull ImplementationTO var1);

    @DELETE
    @Path(value="{type}/{key}")
    @Produces(value={"application/json", "application/yaml", "application/xml"})
    public Response delete(@NotNull @PathParam(value="type") String var1, @NotNull @PathParam(value="key") String var2);
}

