/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.starter;

import java.util.Comparator;
import org.apache.syncope.common.keymaster.client.api.model.NetworkService;
import org.apache.syncope.common.keymaster.client.api.startstop.KeymasterStop;
import org.apache.syncope.core.persistence.api.DomainHolder;
import org.apache.syncope.core.persistence.api.SyncopeCoreLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.core.Ordered;

public class SyncopeCoreStop
extends KeymasterStop
implements Ordered {
    private static final Logger LOG = LoggerFactory.getLogger(SyncopeCoreStop.class);
    private final DomainHolder<?> domainHolder;

    public SyncopeCoreStop(DomainHolder<?> domainHolder) {
        super(NetworkService.Type.CORE);
        this.domainHolder = domainHolder;
    }

    public int getOrder() {
        return 0;
    }

    public void onApplicationEvent(ContextClosedEvent event) {
        event.getApplicationContext().getBeansOfType(SyncopeCoreLoader.class).values().stream().sorted(Comparator.comparing(Ordered::getOrder).reversed()).forEachOrdered(loader -> {
            String loaderName = AopUtils.getTargetClass((Object)loader).getName();
            LOG.debug("[{}#{}] Starting dispose", (Object)loaderName, (Object)loader.getOrder());
            this.domainHolder.getDomains().forEach((domain, datasource) -> {
                LOG.debug("[{}] Starting dispose on domain '{}'", (Object)loaderName, domain);
                loader.unload(domain);
                LOG.debug("[{}] Dispose completed on domain '{}'", (Object)loaderName, domain);
            });
            loader.unload();
            LOG.debug("[{}] Dispose completed", (Object)loaderName);
        });
        super.onApplicationEvent(event);
    }
}

