/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.lib.types;

import jakarta.ws.rs.core.Response;

public enum ExecStatus {
    CREATED(Response.Status.CREATED.getStatusCode()),
    SUCCESS(Response.Status.OK.getStatusCode()),
    FAILURE(Response.Status.BAD_REQUEST.getStatusCode()),
    NOT_ATTEMPTED(Response.Status.PRECONDITION_REQUIRED.getStatusCode());

    protected int httpStatus;

    private ExecStatus(int httpStatus) {
        this.httpStatus = httpStatus;
    }

    public int getHttpStatus() {
        return this.httpStatus;
    }

    public static ExecStatus fromHttpStatus(int httpStatus) {
        ExecStatus status = null;
        for (ExecStatus value : ExecStatus.values()) {
            if (httpStatus != value.getHttpStatus()) continue;
            status = value;
        }
        if (status == null && httpStatus == Response.Status.NO_CONTENT.getStatusCode()) {
            return SUCCESS;
        }
        return status;
    }
}

