/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.job.service.impl.cmd;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.flowable.common.engine.api.delegate.event.FlowableEngineEventType;
import org.flowable.common.engine.api.delegate.event.FlowableEvent;
import org.flowable.common.engine.api.delegate.event.FlowableEventDispatcher;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.job.service.JobServiceConfiguration;
import org.flowable.job.service.event.impl.FlowableJobEventBuilder;
import org.flowable.job.service.impl.persistence.entity.JobEntity;
import org.flowable.job.service.impl.persistence.entity.TimerJobEntity;

public class CancelJobsCmd
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected JobServiceConfiguration jobServiceConfiguration;
    protected List<String> jobIds;

    public CancelJobsCmd(List<String> jobIds, JobServiceConfiguration jobServiceConfiguration) {
        this.jobIds = jobIds;
        this.jobServiceConfiguration = jobServiceConfiguration;
    }

    public CancelJobsCmd(String jobId, JobServiceConfiguration jobServiceConfiguration) {
        this.jobIds = new ArrayList<String>();
        this.jobIds.add(jobId);
        this.jobServiceConfiguration = jobServiceConfiguration;
    }

    public Void execute(CommandContext commandContext) {
        JobEntity jobToDelete = null;
        for (String jobId : this.jobIds) {
            jobToDelete = (JobEntity)this.jobServiceConfiguration.getJobEntityManager().findById(jobId);
            FlowableEventDispatcher eventDispatcher = this.jobServiceConfiguration.getEventDispatcher();
            if (jobToDelete != null) {
                if (eventDispatcher != null && eventDispatcher.isEnabled()) {
                    eventDispatcher.dispatchEvent((FlowableEvent)FlowableJobEventBuilder.createEntityEvent(FlowableEngineEventType.JOB_CANCELED, jobToDelete), this.jobServiceConfiguration.getEngineName());
                }
                this.jobServiceConfiguration.getJobEntityManager().delete(jobToDelete);
                continue;
            }
            TimerJobEntity timerJobToDelete = (TimerJobEntity)this.jobServiceConfiguration.getTimerJobEntityManager().findById(jobId);
            if (timerJobToDelete == null) continue;
            if (eventDispatcher != null && eventDispatcher.isEnabled()) {
                eventDispatcher.dispatchEvent((FlowableEvent)FlowableJobEventBuilder.createEntityEvent(FlowableEngineEventType.JOB_CANCELED, timerJobToDelete), this.jobServiceConfiguration.getEngineName());
            }
            this.jobServiceConfiguration.getTimerJobEntityManager().delete(timerJobToDelete);
        }
        return null;
    }
}

