/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.plugins.baseplugin.conditions;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.unomi.api.conditions.Condition;
import org.apache.unomi.api.services.DefinitionsService;
import org.apache.unomi.api.services.SegmentService;
import org.apache.unomi.api.utils.ConditionBuilder;
import org.apache.unomi.persistence.elasticsearch.conditions.ConditionContextHelper;
import org.apache.unomi.persistence.elasticsearch.conditions.ConditionESQueryBuilder;
import org.apache.unomi.persistence.elasticsearch.conditions.ConditionESQueryBuilderDispatcher;
import org.apache.unomi.persistence.spi.PersistenceService;
import org.apache.unomi.persistence.spi.aggregate.BaseAggregate;
import org.apache.unomi.persistence.spi.aggregate.TermsAggregate;
import org.apache.unomi.scripting.ScriptExecutor;
import org.elasticsearch.index.query.QueryBuilder;

public class PastEventConditionESQueryBuilder
implements ConditionESQueryBuilder {
    private DefinitionsService definitionsService;
    private PersistenceService persistenceService;
    private SegmentService segmentService;
    private ScriptExecutor scriptExecutor;
    private int maximumIdsQueryCount = 5000;
    private int aggregateQueryBucketSize = 5000;
    private boolean pastEventsDisablePartitions = false;

    public void setDefinitionsService(DefinitionsService definitionsService) {
        this.definitionsService = definitionsService;
    }

    public void setPersistenceService(PersistenceService persistenceService) {
        this.persistenceService = persistenceService;
    }

    public void setScriptExecutor(ScriptExecutor scriptExecutor) {
        this.scriptExecutor = scriptExecutor;
    }

    public void setMaximumIdsQueryCount(int maximumIdsQueryCount) {
        this.maximumIdsQueryCount = maximumIdsQueryCount;
    }

    public void setAggregateQueryBucketSize(int aggregateQueryBucketSize) {
        this.aggregateQueryBucketSize = aggregateQueryBucketSize;
    }

    public void setPastEventsDisablePartitions(boolean pastEventsDisablePartitions) {
        this.pastEventsDisablePartitions = pastEventsDisablePartitions;
    }

    public void setSegmentService(SegmentService segmentService) {
        this.segmentService = segmentService;
    }

    public QueryBuilder buildQuery(Condition condition, Map<String, Object> context, ConditionESQueryBuilderDispatcher dispatcher) {
        boolean eventsOccurred = PastEventConditionESQueryBuilder.getStrategyFromOperator((String)condition.getParameter("operator"));
        int minimumEventCount = !eventsOccurred || condition.getParameter("minimumEventCount") == null ? 1 : (Integer)condition.getParameter("minimumEventCount");
        int maximumEventCount = !eventsOccurred || condition.getParameter("maximumEventCount") == null ? Integer.MAX_VALUE : (Integer)condition.getParameter("maximumEventCount");
        String generatedPropertyKey = (String)condition.getParameter("generatedPropertyKey");
        if (generatedPropertyKey != null && generatedPropertyKey.equals(this.segmentService.getGeneratedPropertyKey((Condition)condition.getParameter("eventCondition"), condition))) {
            return dispatcher.buildFilter(this.getProfileConditionForCounter(generatedPropertyKey, minimumEventCount, maximumEventCount, eventsOccurred), context);
        }
        Condition eventCondition = PastEventConditionESQueryBuilder.getEventCondition(condition, context, null, this.definitionsService, this.scriptExecutor);
        Set<String> ids = this.getProfileIdsMatchingEventCount(eventCondition, minimumEventCount, maximumEventCount);
        ConditionBuilder conditionBuilder = this.definitionsService.getConditionBuilder();
        return dispatcher.buildFilter(conditionBuilder.condition("idsCondition").parameter("ids", ids).parameter("match", (Object)eventsOccurred).build(), context);
    }

    public long count(Condition condition, Map<String, Object> context, ConditionESQueryBuilderDispatcher dispatcher) {
        boolean eventsOccurred = PastEventConditionESQueryBuilder.getStrategyFromOperator((String)condition.getParameter("operator"));
        int minimumEventCount = !eventsOccurred || condition.getParameter("minimumEventCount") == null ? 1 : (Integer)condition.getParameter("minimumEventCount");
        int maximumEventCount = !eventsOccurred || condition.getParameter("maximumEventCount") == null ? Integer.MAX_VALUE : (Integer)condition.getParameter("maximumEventCount");
        String generatedPropertyKey = (String)condition.getParameter("generatedPropertyKey");
        if (generatedPropertyKey != null && generatedPropertyKey.equals(this.segmentService.getGeneratedPropertyKey((Condition)condition.getParameter("eventCondition"), condition))) {
            return this.persistenceService.queryCount(this.getProfileConditionForCounter(generatedPropertyKey, minimumEventCount, maximumEventCount, eventsOccurred), "profile");
        }
        Condition eventCondition = PastEventConditionESQueryBuilder.getEventCondition(condition, context, null, this.definitionsService, this.scriptExecutor);
        if (eventsOccurred && minimumEventCount == 1 && maximumEventCount == Integer.MAX_VALUE) {
            return ((Double)this.persistenceService.getSingleValuesMetrics(eventCondition, new String[]{"card"}, "profileId.keyword", "event").get("_card")).longValue();
        }
        Set<String> profileIds = this.getProfileIdsMatchingEventCount(eventCondition, minimumEventCount, maximumEventCount);
        ConditionBuilder conditionBuilder = this.definitionsService.getConditionBuilder();
        return eventsOccurred ? (long)profileIds.size() : this.persistenceService.queryCount(conditionBuilder.condition("idsCondition").parameter("ids", profileIds).parameter("match", (Object)false).build(), "profile");
    }

    protected static boolean getStrategyFromOperator(String operator) {
        if (operator != null && !operator.equals("eventsOccurred") && !operator.equals("eventsNotOccurred")) {
            throw new UnsupportedOperationException("Unsupported operator: " + operator + ", please use either 'eventsOccurred' or 'eventsNotOccurred'");
        }
        return operator == null || operator.equals("eventsOccurred");
    }

    private Condition getProfileConditionForCounter(String generatedPropertyKey, Integer minimumEventCount, Integer maximumEventCount, boolean eventsOccurred) {
        if (eventsOccurred) {
            return this.createEventOccurredCondition(generatedPropertyKey, minimumEventCount, maximumEventCount);
        }
        return this.createEventNotOccurredCondition(generatedPropertyKey);
    }

    private Condition createEventOccurredCondition(String generatedPropertyKey, Integer minimumEventCount, Integer maximumEventCount) {
        ConditionBuilder conditionBuilder = this.definitionsService.getConditionBuilder();
        ConditionBuilder.ComparisonCondition subConditionCount = conditionBuilder.profileProperty("systemProperties.pastEvents.count").between(minimumEventCount, maximumEventCount);
        ConditionBuilder.ComparisonCondition subConditionKey = conditionBuilder.profileProperty("systemProperties.pastEvents.key").equalTo(generatedPropertyKey);
        ConditionBuilder.CompoundCondition booleanCondition = conditionBuilder.and((ConditionBuilder.ConditionItem)subConditionCount, (ConditionBuilder.ConditionItem)subConditionKey);
        return conditionBuilder.nested((ConditionBuilder.ConditionItem)booleanCondition, "systemProperties.pastEvents").build();
    }

    private Condition createEventNotOccurredCondition(String generatedPropertyKey) {
        ConditionBuilder.ConditionItem counterMissing = this.createPastEventMustNotExistCondition(generatedPropertyKey);
        ConditionBuilder conditionBuilder = this.definitionsService.getConditionBuilder();
        ConditionBuilder.ComparisonCondition counterZero = conditionBuilder.profileProperty("systemProperties.pastEvents.count").equalTo(Integer.valueOf(0));
        ConditionBuilder.ComparisonCondition keyEquals = conditionBuilder.profileProperty("systemProperties.pastEvents.key").equalTo(generatedPropertyKey);
        ConditionBuilder.CompoundCondition keyExistsAndCounterZero = conditionBuilder.and((ConditionBuilder.ConditionItem)counterZero, (ConditionBuilder.ConditionItem)keyEquals);
        ConditionBuilder.NestedCondition nestedKeyExistsAndCounterZero = conditionBuilder.nested((ConditionBuilder.ConditionItem)keyExistsAndCounterZero, "systemProperties.pastEvents");
        return conditionBuilder.or(counterMissing, (ConditionBuilder.ConditionItem)nestedKeyExistsAndCounterZero).build();
    }

    private ConditionBuilder.ConditionItem createPastEventMustNotExistCondition(String generatedPropertyKey) {
        ConditionBuilder conditionBuilder = this.definitionsService.getConditionBuilder();
        ConditionBuilder.ComparisonCondition keyEquals = conditionBuilder.profileProperty("systemProperties.pastEvents.key").equalTo(generatedPropertyKey);
        return conditionBuilder.not((ConditionBuilder.ConditionItem)keyEquals);
    }

    private Set<String> getProfileIdsMatchingEventCount(Condition eventCondition, int minimumEventCount, int maximumEventCount) {
        boolean noBoundaries;
        boolean bl = noBoundaries = minimumEventCount == 1 && maximumEventCount == Integer.MAX_VALUE;
        if (this.pastEventsDisablePartitions) {
            Map eventCountByProfile = this.persistenceService.aggregateWithOptimizedQuery(eventCondition, (BaseAggregate)new TermsAggregate("profileId"), "event", this.maximumIdsQueryCount);
            eventCountByProfile.remove("_filtered");
            return noBoundaries ? eventCountByProfile.keySet() : eventCountByProfile.entrySet().stream().filter(eventCountPerProfile -> (Long)eventCountPerProfile.getValue() >= (long)minimumEventCount && (Long)eventCountPerProfile.getValue() <= (long)maximumEventCount).map(Map.Entry::getKey).collect(Collectors.toSet());
        }
        HashSet<String> result = new HashSet<String>();
        Map m = this.persistenceService.getSingleValuesMetrics(eventCondition, new String[]{"card"}, "profileId.keyword", "event");
        long card = ((Double)m.get("_card")).longValue();
        int numParts = (int)(card / (long)this.aggregateQueryBucketSize) + 2;
        for (int i = 0; i < numParts; ++i) {
            Map eventCountByProfile = this.persistenceService.aggregateWithOptimizedQuery(eventCondition, (BaseAggregate)new TermsAggregate("profileId", i, numParts), "event");
            if (eventCountByProfile == null) continue;
            eventCountByProfile.remove("_filtered");
            if (noBoundaries) {
                result.addAll(eventCountByProfile.keySet());
                continue;
            }
            for (Map.Entry entry : eventCountByProfile.entrySet()) {
                if ((Long)entry.getValue() < (long)minimumEventCount) break;
                if ((Long)entry.getValue() > (long)maximumEventCount) continue;
                result.add((String)entry.getKey());
            }
        }
        return result;
    }

    protected static Condition getEventCondition(Condition condition, Map<String, Object> context, String profileId, DefinitionsService definitionsService, ScriptExecutor scriptExecutor) {
        Condition eventCondition;
        try {
            eventCondition = (Condition)condition.getParameter("eventCondition");
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Empty eventCondition");
        }
        if (eventCondition == null) {
            throw new IllegalArgumentException("No eventCondition");
        }
        ArrayList<Condition> l = new ArrayList<Condition>();
        Condition andCondition = new Condition();
        andCondition.setConditionType(definitionsService.getConditionType("booleanCondition"));
        andCondition.setParameter("operator", (Object)"and");
        andCondition.setParameter("subConditions", l);
        l.add(ConditionContextHelper.getContextualCondition((Condition)eventCondition, context, (ScriptExecutor)scriptExecutor));
        if (profileId != null) {
            Condition profileCondition = new Condition();
            profileCondition.setConditionType(definitionsService.getConditionType("sessionPropertyCondition"));
            profileCondition.setParameter("propertyName", (Object)"profileId");
            profileCondition.setParameter("comparisonOperator", (Object)"equals");
            profileCondition.setParameter("propertyValue", (Object)profileId);
            l.add(profileCondition);
        }
        Integer numberOfDays = (Integer)condition.getParameter("numberOfDays");
        String fromDate = (String)condition.getParameter("fromDate");
        String toDate = (String)condition.getParameter("toDate");
        if (numberOfDays != null) {
            l.add(PastEventConditionESQueryBuilder.getTimeStampCondition("greaterThan", "propertyValueDateExpr", "now-" + numberOfDays + "d", definitionsService));
        }
        if (fromDate != null) {
            l.add(PastEventConditionESQueryBuilder.getTimeStampCondition("greaterThanOrEqualTo", "propertyValueDate", fromDate, definitionsService));
        }
        if (toDate != null) {
            l.add(PastEventConditionESQueryBuilder.getTimeStampCondition("lessThanOrEqualTo", "propertyValueDate", toDate, definitionsService));
        }
        return andCondition;
    }

    private static Condition getTimeStampCondition(String operator, String propertyValueParameter, Object propertyValue, DefinitionsService definitionsService) {
        Condition endDateCondition = new Condition();
        endDateCondition.setConditionType(definitionsService.getConditionType("sessionPropertyCondition"));
        endDateCondition.setParameter("propertyName", (Object)"timeStamp");
        endDateCondition.setParameter("comparisonOperator", (Object)operator);
        endDateCondition.setParameter(propertyValueParameter, propertyValue);
        return endDateCondition;
    }
}

