/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.form;

import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.danekja.java.util.function.serializable.SerializableFunction;

public class LambdaChoiceRenderer<T>
implements IChoiceRenderer<T> {
    private static final long serialVersionUID = 1L;
    private final SerializableFunction<T, ?> displayExpression;
    private final SerializableFunction<T, ?> idExpression;

    public LambdaChoiceRenderer() {
        this(null);
    }

    public LambdaChoiceRenderer(SerializableFunction<T, ?> displayExpression) {
        this(displayExpression, null);
    }

    public LambdaChoiceRenderer(SerializableFunction<T, ?> displayExpression, SerializableFunction<T, ?> idExpression) {
        this.displayExpression = displayExpression;
        this.idExpression = idExpression;
    }

    @Override
    public Object getDisplayValue(T object) {
        Object returnValue = object;
        if (this.displayExpression != null && object != null) {
            returnValue = this.displayExpression.apply(object);
        }
        if (returnValue == null) {
            return "";
        }
        return returnValue;
    }

    @Override
    public String getIdValue(T object, int index) {
        if (this.idExpression == null) {
            return Integer.toString(index);
        }
        if (object == null) {
            return "";
        }
        Object returnValue = this.idExpression.apply(object);
        if (returnValue == null) {
            return "";
        }
        return returnValue.toString();
    }
}

